<?php
/*
# ------------------------------------------------------------------------
# JA Bulletin module for Joomla 1.5
# ------------------------------------------------------------------------
# Copyright (C) 2004-2010 JoomlArt.com. All Rights Reserved.
# @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
# Author: JoomlArt.com
# Websites: http://www.joomlart.com - http://www.joomlancers.com.
# ------------------------------------------------------------------------
*/
// no direct access
defined ( '_JEXEC' ) or die ( 'Restricted access' );

require_once (JPATH_SITE . DS . 'components' . DS . 'com_content' . DS . 'helpers' . DS . 'route.php');
//Check com k2 was installed
if(file_exists(JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'route.php'))
{
	require_once(JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'route.php');
}
if(file_exists(JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'utilities.php'))
{
	require_once(JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'utilities.php');
}
//end check
if (! class_exists ( 'modJABulletin' )) {
	class modJABulletin {
		function getMostRead(&$params) {
			global $mainframe;
			
			$db = & JFactory::getDBO ();
			$user = & JFactory::getUser ();
			
			$count = intval ( $params->get ( 'count', 5 ) );
			$catid = trim ( $params->get ( 'catid' ) );
			$secid = trim ( $params->get ( 'secid' ) );
			$show_front = $params->get ( 'show_front', 1 );
			$aid = $user->get ( 'aid', 0 );
			
			$contentConfig = &JComponentHelper::getParams ( 'com_content' );
			$access = ! $contentConfig->get ( 'shownoauth' );
			
			$nullDate = $db->getNullDate ();
			$date = & JFactory::getDate ();
			$now = $date->toMySQL ();
			
			$catid = $params->get ( 'category' );
			if (! is_array ( $catid ) && $catid != '') {
				$catid = preg_split ( '/,/', $catid );
			}
			
			if ($catid) {
				$catCondition = ' AND cc.id IN ("' . implode ( '","', $catid ) . '")';
			} 
			
			if ($secid) {
				$ids = explode( ',', $secid );
				JArrayHelper::toInteger( $ids );
				$secCondition = ' AND (s.id=' . implode( ' OR s.id=', $ids ) . ')';
			}
			//Content Items only
			$front_join = "";
			if($show_front == '2')
			{
				$front_join = '	INNER JOIN #__content_frontpage AS f ON f.content_id = a.id	';
			}
			elseif($show_front == '0')
			{
				$front_join = '	LEFT JOIN #__content_frontpage AS f ON f.content_id = a.id	';
			}
			$query = 'SELECT a.*,u.name as creater,' . ' CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(":", a.id, a.alias) ELSE a.id END as slug,' . ' CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(":", cc.id, cc.alias) ELSE cc.id END as catslug' . ' FROM #__content AS a' . 
			$front_join . 
			' INNER JOIN #__categories AS cc ON cc.id = a.catid' . ' INNER JOIN #__sections AS s ON s.id = a.sectionid' .
			' LEFT JOIN #__users AS u ON a.created_by = u.id'.
			' WHERE ( a.state = 1 AND s.id > 0 )' . ' AND ( a.publish_up = ' . $db->Quote ( $nullDate ) . ' OR a.publish_up <= ' . $db->Quote ( $now ) . ' )' . ' AND ( a.publish_down = ' . $db->Quote ( $nullDate ) . ' OR a.publish_down >= ' . $db->Quote ( $now ) . ' )' . ($access ? ' AND a.access <= ' . ( int ) $aid . ' AND cc.access <= ' . ( int ) $aid . ' AND s.access <= ' . ( int ) $aid : '') . ($catid ? $catCondition : '') . ($secid ? $secCondition : '') . ($show_front == '0' ? ' AND f.content_id IS NULL' : '') . ' AND s.published = 1' . ' AND cc.published = 1' . ' ORDER BY a.hits DESC';
			$db->setQuery ( $query, 0, $count );
			$rows = $db->loadObjectList ();
			
			return $rows;
		}
		
		function getLatest(&$params) {
			global $mainframe;
			
			$db = & JFactory::getDBO ();
			$user = & JFactory::getUser ();
			$userId = ( int ) $user->get ( 'id' );
			
			$count = ( int ) $params->get ( 'count', 5 );
			
			$catid = $params->get ( 'category' );
			if (! is_array ( $catid ) && $catid != '') {
				$catid = preg_split ( '/,/', $catid );
			}
			
			
			 $secid		= trim( $params->get('secid') );
			

			$show_front = $params->get ( 'show_front', 1 );
			$aid = $user->get ( 'aid', 0 );
			
			$contentConfig = &JComponentHelper::getParams ( 'com_content' );
			$access = ! $contentConfig->get ( 'shownoauth' );
			
			$nullDate = $db->getNullDate ();
			
			$date = & JFactory::getDate ();
			$now = $date->toMySQL ();
			
			$where = 'a.state = 1' . ' AND ( a.publish_up = ' . $db->Quote ( $nullDate ) . ' OR a.publish_up <= ' . $db->Quote ( $now ) . ' )' . ' AND ( a.publish_down = ' . $db->Quote ( $nullDate ) . ' OR a.publish_down >= ' . $db->Quote ( $now ) . ' )';
			
			// User Filter
			switch ($params->get ( 'user_id' )) {
				case 'by_me' :
					$where .= ' AND (created_by = ' . ( int ) $userId . ' OR modified_by = ' . ( int ) $userId . ')';
					break;
				case 'not_me' :
					$where .= ' AND (created_by <> ' . ( int ) $userId . ' AND modified_by <> ' . ( int ) $userId . ')';
					break;
			}
			
			// Ordering
			switch ($params->get ( 'ordering' )) {
				case 'm_dsc' :
					$ordering = 'a.modified DESC, a.created DESC';
					break;
				case 'c_dsc' :
				default :
					$ordering = 'a.created DESC';
					break;
			}
		
			if ($catid) {
				$catCondition = ' AND cc.id IN ("' . implode ( '","', $catid ) . '")';
			}
			if ($secid) {
				$ids = explode ( ',', $secid );
				JArrayHelper::toInteger ( $ids );
				$secCondition = ' AND (s.id=' . implode ( ' OR s.id=', $ids ) . ')';
			}
			
			// Content Items only
			//show_front =
			//1: show all articles (front artilces and not front artilces)
			//2: show only front articles
			$front_join = "";
			if($show_front == '2')
			{
				$front_join = '	INNER JOIN #__content_frontpage AS f ON f.content_id = a.id	';
			}
			elseif($show_front == '0')
			{
				$front_join = '	LEFT JOIN #__content_frontpage AS f ON f.content_id = a.id	';
			}
			$query = 'SELECT a.*,u.name as creater, ' . 
							' CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(":", a.id, a.alias) ELSE a.id END as slug,' . 
							' CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(":", cc.id, cc.alias) ELSE cc.id END as catslug' . 
							' FROM #__content AS a' . 
							 $front_join . 
							' INNER JOIN #__categories AS cc ON cc.id = a.catid' . 
							' INNER JOIN #__sections AS s ON s.id = a.sectionid' .
							' LEFT JOIN #__users AS u ON a.created_by = u.id'.
							' WHERE ' . $where . ' AND s.id > 0' . ($access ? ' AND a.access <= ' . ( int ) $aid . 
							($show_front == '0' ? ' AND f.content_id IS NULL' : '').
							' AND cc.access <= ' . ( int ) $aid . 
							' AND s.access <= ' . ( int ) $aid : '') . ($catid ? $catCondition : '') . ($secid ? $secCondition : '')  . ' AND s.published = 1' . ' AND cc.published = 1' . 
							' ORDER BY ' . $ordering;
			$db->setQuery ( $query, 0, $count );
			$rows = $db->loadObjectList ();
			return $rows;
		}
		
		function getListArtilceIds($params)
		{
		   global $mainframe;
			
			$db = & JFactory::getDBO ();
			$user = & JFactory::getUser ();
			$userId = ( int ) $user->get ( 'id' );
			
			$count = ( int ) $params->get ( 'count', 5 );
			
			$catid = $params->get ( 'category' );
			if (! is_array ( $catid ) && $catid != '') {
				$catid = preg_split ( '/,/', $catid );
			}
			
			
			 $secid		= trim( $params->get('secid') );
			

			$show_front = $params->get ( 'show_front', 1 );
			
			// User Filter
			switch ($params->get ( 'user_id' )) {
				case 'by_me' :
					$where .= ' AND (created_by = ' . ( int ) $userId . ' OR modified_by = ' . ( int ) $userId . ')';
					break;
				case 'not_me' :
					$where .= ' AND (created_by <> ' . ( int ) $userId . ' AND modified_by <> ' . ( int ) $userId . ')';
					break;
			}
			if ($catid) {
				$catCondition = ' AND cc.id IN ("' . implode ( '","', $catid ) . '")';
			}
			if ($secid) {
				$ids = explode ( ',', $secid );
				JArrayHelper::toInteger ( $ids );
				$secCondition = ' AND (s.id=' . implode ( ' OR s.id=', $ids ) . ')';
			}
			// Content Items only
			$query = 'SELECT a.id'.
						' FROM #__content AS a' . 
						($show_front == '1' ? ' INNER JOIN #__content_frontpage AS f ON f.content_id = a.id' : '') . 
						' INNER JOIN #__categories AS cc ON cc.id = a.catid' . 
						' INNER JOIN #__sections AS s ON s.id = a.sectionid' . 
						' WHERE  s.id > 0' . ($catid ? $catCondition : '') . ($secid ? $secCondition : '')  . ' AND s.published = 1' . ' AND cc.published = 1' ;
			$db->setQuery ( $query, 0, $count );
			$rows = $db->loadObjectList ();
			
			return $rows;
		}
		
		function parseList(&$rows, &$params) {
			$i = 0;
			$showHits = $params->get('show_hits',0);
			$showHits = $showHits == "1"?true:false;
			$showimg = $params->get ( 'show_image', 1 );
			$w = ( int ) $params->get ( 'width', 80 );
			$h = ( int ) $params->get ( 'height', 96 );
			$showdate = $params->get ( 'show_date', 1 );
		
			$thumbnailMode = $params->get( 'thumbnail_mode', 'crop' );
			$aspect 	   = $params->get( 'thumbnail_mode-resize-use_ratio', '1' );
			$crop = $thumbnailMode == 'crop' ? true:false;
			$lists = array ();
			$jaimage = JAImage::getInstance();
			$using_mode = $params->get( 'using_mode', 'catids' );
				
			foreach ( $rows as $row ) {
				if($using_mode == "com_k2")
				{
					$lists [$i]->link = urldecode(JRoute::_(K2HelperRoute::getItemRoute($row->id.':'.urlencode($row->alias), $row->catid.':'.urlencode($row->categoryalias))));
				}
				else
				{
					$lists [$i]->link = JRoute::_ ( ContentHelperRoute::getArticleRoute ( $row->slug, $row->catslug, $row->sectionid ) );
				}
				$lists [$i]->text = htmlspecialchars ( $row->title );
				if ($showdate) {
					$lists [$i]->date = strtotime ( $row->modified ) ? $row->modified : $row->created ;
				}
				if ($showimg) {
					$imageSource = "";
				   if($using_mode == "com_k2")
				   {
						if (JFile::exists(JPATH_SITE.DS.'media'.DS.'k2'.DS.'items'.DS.'cache'.DS.md5("Image".$row->id).'_Generic.jpg'))
							$imageSource = JURI::root().'media/k2/items/cache/'.md5("Image".$row->id).'_Generic.jpg';
							
				   }
				  if(empty($imageSource ))
				   {
						$imageSource = $jaimage->parseImage( $row->introtext . $row->fulltext );
				  }
					if ( $imageSource ) { 
						if( $thumbnailMode != 'none' ) {
							$imageURL = $jaimage->resize( $imageSource, $w, $h, $crop, $aspect );
							if( $imageURL ){
								if ( $imageURL == $imageSource ) {
									$width = $w ? "width=\"$w\"" : "";
									$height = $h ? "height=\"$h\"" : "";
									$lists [$i]->image = "<img src=\"$imageURL\" alt=\"{$lists[$i]->text}\" title=\"{$lists[$i]->text}\" $width $height />";
								} else {
									$lists [$i]->image = "<img src=\"$imageURL\" alt=\"{$lists[$i]->text}\" title=\"{$lists[$i]->text}\" />";
								}
							} else {
								$lists [$i]->image = '';
							}
						} else {
							$width = $w ? "width=\"$w\"" : "";
							$height = $h ? "height=\"$h\"" : "";
							$lists [$i]->image = "<img src=\"$imageSource\" alt=\"{$lists[$i]->text}\" title=\"{$lists[$i]->text}\" $width $height />";	
						}	
					}
				}
				$lists[$i]->creater = isset($row->creater)?$row->creater:"";
				if($showHits)
				{
					$lists[$i]->hits = isset($row->hits)?$row->hits:0;
				}
				else
				{
					$lists[$i]->hits = null;
				}
				$i ++;
			}
			
			return $lists;
		}
		function getK2List( $params , $ordering = "a.hits DESC" )
		{
			global $mainframe;
		
		 	$db	    = &JFactory::getDBO();
			
			$my = &JFactory::getUser();

			$aid	= $my->get( 'aid', 0 );
			$date =& JFactory::getDate();
			$now  = $date->toMySQL();
			// User Filter
			switch ($params->get ( 'user_id' )) {
				case 'by_me' :
					$where .= ' AND (created_by = ' . ( int ) $userId . ' OR modified_by = ' . ( int ) $userId . ')';
					break;
				case 'not_me' :
					$where .= ' AND (created_by <> ' . ( int ) $userId . ' AND modified_by <> ' . ( int ) $userId . ')';
					break;
			}
			
			$query = "SELECT a.*,u.name as creater, cc.name AS categoryname,cc.id AS categoryid, cc.alias AS categoryalias, cc.params AS categoryparams";
			$query .= " FROM #__k2_items as a LEFT JOIN #__k2_categories cc ON cc.id = a.catid";
			$query .= " left JOIN #__users AS u ON a.created_by = u.id";
			$query .= " WHERE a.published = 1 AND a.access <= {$aid} AND a.trash = 0 AND cc.published = 1 AND cc.access <= {$aid} AND cc.trash = 0";
			$query .= " AND ( a.publish_up = ".$db->Quote( $db->getNullDate() )." OR a.publish_up <= ".$db->Quote($now)." )";
			$query .= " AND ( a.publish_down = ".$db->Quote( $db->getNullDate() )." OR a.publish_down >= ".$db->Quote($now)." )";
			
			if(is_array($params->get('k2catsid'))){
				$catids = implode(',', $params->get('k2catsid'));
				$query .= " AND cc.id IN($catids)";
			}
			elseif($params->get('k2catsid')>0){
				$catids = $params->get('k2catsid');
				$query .= " AND cc.id = $catids";
			}
			$query .= ' ORDER BY '.$ordering;
		
			if($params->get('count', 5)){
				$query .=  ' LIMIT ' . $params->get('count', 5);
			}
			$db->setQuery($query);
			
			return $db->loadObjectlist();
		
		}
		function getK2Latest( $params )
		{
			// Ordering
			$ordering = null;
			switch ($params->get ( 'ordering' )) {
				case 'm_dsc' :
					$ordering = 'a.modified DESC, a.created DESC';
					break;
				case 'c_dsc' :
				default :
					$ordering = 'a.created DESC';
					break;
			}
			$rows = $this->getK2List( $params , $ordering );
			return $rows;
		}
		function getK2MostRead( $params )
		{
			$rows = $this->getK2List( $params , "a.hits DESC");
			return $rows;
		}
		function getListK2( $params )
		{
			$type = $params->get ( 'type', 'latest' );
			$rows = null;
			switch ($type) {
				case 'latest' :
					$rows = $this->getK2Latest ( $params );
					break;
				case 'mostread' :
					$rows = $this->getK2MostRead ( $params );
					break;
			}
			return $rows;
		}
		function getListJoomContents($params)
		{
		    $type = $params->get ( 'type', 'latest' );
			$rows = null;
			switch ($type) {
				case 'latest' :
					$rows = $this->getLatest ( $params );
					break;
				case 'mostread' :
					$rows = $this->getMostRead ( $params );
					break;
			}
			return $rows;
		}
		function getList(&$params) {
			$using_mode = $params->get( 'using_mode', 'catids' );
			if($using_mode == "com_k2")
			{
			   $rows = $this->getListK2($params);
			}
			else
			{
				$rows = $this->getListJoomContents($params);
			}
			
			if (isset ( $rows ))
				return $this->parseList ( $rows, $params );
			return null;
		}
		
		function addStyleFiles() {
			global $mainframe;
			$filename = 'style.css';
			$tplpath = DS . 'templates' . DS . $mainframe->getTemplate () . DS . 'css' . DS;
			$tplurl = '/templates/' . $mainframe->getTemplate () . '/css/';
			$modurl = 'modules/mod_jabulletin/assets/';
			$cssurl = $tplurl;
			if (! file_exists ( JPATH_SITE . $tplpath . $filename )) {
				$cssurl = $modurl;
			}
			$cssurl = JURI::base () . $cssurl;
			?>
			<script type="text/javascript">
				//<![CDATA[ 
					var links = document.getElementsByTagName ('link');
					var script = document.createElement('link');
					script.setAttribute('type', 'text/css');
					script.setAttribute('rel', 'stylesheet');
					script.setAttribute('href', '<?php
		echo $cssurl . $filename;
		?>');
					document.getElementsByTagName("head")[0].appendChild(script);
				
				//]]>
				</script>
<?php
		}
	}
}
